<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.0 Alpha 5
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2009 Jelsoft Enterprises Ltd. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

/**
*	This file is a bucket in which functions common to both the
* install and the upgrade can be located.  
*/

if (!defined('VB_AREA') AND !defined('THIS_SCRIPT'))
{
	echo 'VB_AREA or THIS_SCRIPT must be defined to continue';
	exit;
}

// #####################################################################
// Determines which mysql engine to use for high concurrency tables 
// Will use InnoDB if its available, otherwise MyISAM
function get_high_concurrency_table_engine($db)
{
	$set = $db->query('SHOW ENGINES');
	
	while ($row = $db->fetch_row($set))
	{
		if (
			strcasecmp($row['Engine'], 'innodb') == 0 AND 
			((strcasecmp($row['Engine'], 'yes') == 0) OR (strcasecmp($row['Engine'], 'default') == 0))
		)
		{
			return 'InnoDB';
		}

	}
	return 'MyISAM';
}

function should_install_suite()
{
	$suite_products = array('vbblog', 'vbcms', 'vbcms');
	
	foreach ($suite_products as $productid)
	{
		if (file_exists(DIR . "/includes/xml/product-$productid.xml"))
		{
			return true;
		}
	}

	return false;
}




/*======================================================================*\
|| ####################################################################

|| # CVS: $RCSfile$ - $Revision: 29116 $
|| ####################################################################
\*======================================================================*/
